package org.msh.tb.bd.tbforms.dhis2.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.List;

/**
 * Created by Mauricio on 06/02/2017.
 * DTO that holds data about exportation response, sent by DHIS2.
 */
@JsonIgnoreProperties({"importOptions"})
public class DataValueResponse {

    private String responseType;
    private String status;
    private String description;
    private ImportCountData importCount;
    private List<ConflictData> conflicts;
    private boolean dataSetComplete;

    public String getResponseType() {
        return responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImportCountData getImportCount() {
        return importCount;
    }

    public void setImportCount(ImportCountData importCount) {
        this.importCount = importCount;
    }

    public boolean isDataSetComplete() {
        return dataSetComplete;
    }

    public void setDataSetComplete(boolean dataSetComplete) {
        this.dataSetComplete = dataSetComplete;
    }

    public List<ConflictData> getConflicts() {
        return conflicts;
    }

    public void setConflicts(List<ConflictData> conflicts) {
        this.conflicts = conflicts;
    }
}
